## Состояние вещей
Текущая картина мира, к сожалению, такая:
  * команда `hostman`'а занимается разработкой и эксплуатацией сервиса конфигурации железных хостов в RTC
  * осуществляет работы по выкладке новых релизов, которые генерирует она сама и смежные команды

Причины этого (пока?) выходят за рамки данного документа, но важный вывод:
**все изменения вносит де-факто команда `hostman`а в лице его дежурного**.

## User workflow
Исходя из описанного выше текущая последовательность действий для команд:
  * в репозитории [bb/salstack](https://bb.yandex-team.ru/projects/RTCSALT/repos/saltstack/browse) создаётся PR в ветку develop
  Т.е. ответственный за релиз от команды должен выполнить:
     * `git clone ...`
     * `git checkout -b feature/{branch-name}`
     * `git commit -m 'commit message'`
     * `git push origin feature/{branch-name}`
  * создать из полученной ветки Pull Request
  * дождаться выкладки силами дежурного инженера команды `hostman`

Логика работы дежурного описана в документе `DUTY.md`, для пользователей она формулируется так:
  * PR будет выкачен с 11:00 до 19:00 по Мск с понедельника по пятницу включительно
  * Если PR был создан после 11:00, то он будет выкачен в следующий рабочий день

Если:
  * есть пожелания по времени выкладки
  * есть пожелания по уведомлению о начале выкладки
  * **релиз срочный** и не ждёт

нужно обратиться [к текущему дежурному](https://abc.yandex-team.ru/services/hostmanager/duty/) через Telegram, либо призвать в чате `[RTC] Внутренний`.

## Что может пойти не так.
К сожалению, хост система - это огромный [shared state](https://wiki.yandex-team.ru/users/nekto0n/drafts/shared-state-on-host/), где без больших ограничений взаимодействуют различные акторы:
  * сервисы общаются через unix socket'ы
  * сервисы запускают другие процессы
  * сервисы видят процессы других сервисов
  * все живут одном mount namespace'е
  * всё живёт в одном связанном salt'е

Соответственно сервисы **сильно связаны и влияют друг на друга**. Плюс на это накладывается текущий worflow выкладки - 
мы эффективно катаем пачки слабосвязанных изменений, но которые могут влиять друг на друга.

В результате проблема в одном компоненте может сломать многие остальные и pipeline выкладок останавливается.
Это, в свою очередь, останавливает все следующие выкладки - классический __head of the line blocking__.
Просьба к командам учитывать это несовершенство мира.
