class Compiler(object):
    def compile(self, selector):
        """
        Compile component with selector
        :return: CompiledComponent or None, error or None
        """
        raise NotImplementedError()


class CompiledComponent(object):
    def get_packages_actions(self):
        pass

    def apply(self, ctx):
        pass


class AppliedComponent(object):
    def is_noop(self):
        pass

    def persist_lo(self):
        pass

    def process_results(self):
        pass

    def applied(self):
        pass
