import time
from infra.ya_salt.lib.components import component
from infra.ya_salt.lib import pbutil
from infra.ya_salt.lib import constants


class Compiler(component.Compiler):
    def __init__(self, hm_status, hctl, orly_url):
        self.hm_status = hm_status
        self.hctl = hctl
        self.orly_url = orly_url
        self._units_dirs = None

    def compile(self, selector):
        cs = self.hm_status.salt_components.add()
        cs.name = selector.get_name()
        cs.selector = selector.get_match()
        c = CompiledComponent(selector, cs, self.hctl, self.orly_url)
        pbutil.true_cond(cs.initialized)
        return c, None


class CompiledComponent(component.CompiledComponent):
    def __init__(self, selector, status, hctl, orly_url):
        self.selector = selector
        self.status = status
        self.hctl = hctl
        self.orly_url = orly_url
        self.status.skip_reporting = True

    def get_packages_actions(self):
        return tuple(), tuple()

    def apply(self, ctx):
        start_time = time.time()
        # use hostctl has own overrides, so use default repo path
        err = self.hctl.manage_target(constants.LOCAL_REPO_CURRENT, self.selector.get_name(), self.orly_url)
        duration = time.time() - start_time
        if err is None:
            ctx.ok(self.selector.get_match())
        else:
            ctx.fail(self.selector.get_match(), err)
        pbutil.true_cond(self.status.applied, err or 'Ok')
        return AppliedComponent(self.status, err, duration)


class AppliedComponent(component.AppliedComponent):
    def __init__(self, status, err, duration):
        self.status = status
        self.err = err
        self.duration = duration

    def is_noop(self):
        return False

    def persist_lo(self):
        pass

    def process_results(self):
        r = self.status.salt.state_results.add()
        r.id = "__hostctl.{}".format(self.status.name)
        r.comment = 'hostctl manage target: {}'.format(self.err or 'ok')
        r.ok = self.err is None
        r.duration = self.duration

    def applied(self):
        return self.status.applied.status == 'True'
