import time

from infra.ya_salt.lib.components import component
from infra.ya_salt.lib import pbutil


class Compiler(component.Compiler):
    def __init__(self, status, hctl):
        self.status = status
        self.hctl = hctl

    @staticmethod
    def _component_status(status, name, selector):
        s_pb = status.salt_components.add()
        s_pb.name = name
        s_pb.selector = selector.get_match()
        return s_pb

    def compile(self, selector):
        name = selector.get_name()
        unit, err = None, 'unknown virtual component "{}"'.format(name)
        status = self._component_status(self.status, name, selector)

        if name == 'hostctl':
            unit, err = CompiledHostctlComponent(selector, self.status, status, self.hctl), None

        if not err:
            pbutil.true_cond(status.initialized)
        return unit, err


class CompiledHostctlComponent(component.CompiledComponent):
    def __init__(self, selector, hm_status, component_status, hctl):
        self.selector = selector
        self.hm_status = hm_status
        self.status = component_status
        self.hctl = hctl
        self.status.skip_reporting = True

    def get_packages_actions(self):
        return tuple(), tuple()

    def apply(self, ctx):
        start_time = time.time()
        err = self.hctl.report()
        duration = time.time() - start_time
        if err is None:
            pbutil.true_cond(self.hm_status.hostctl.ok, 'OK')
        else:
            pbutil.false_cond(self.hm_status.hostctl.ok, err)
        pbutil.true_cond(self.status.applied, err or 'Ok')
        return AppliedHostctlComponent(self.status, err, duration)


class AppliedHostctlComponent(component.AppliedComponent):
    def __init__(self, status, err, duration):
        self.status = status
        self.err = err
        self.duration = duration

    def is_noop(self):
        return False

    def process_results(self):
        r = self.status.salt.state_results.add()
        r.id = "__virtual.hostctl"
        r.comment = 'hostctl report: {}'.format(self.err or 'ok')
        r.ok = self.err is None
        r.duration = self.duration

    def applied(self):
        return self.status.applied.status == 'True'
