"""
Constants
"""
import os

TIMEOUT_DISABLE = 7200
SIGALARM_SEC = 3600  # Max execution time

RUN_DIR = '/var/run/salt'
VAR_LIB = '/var/lib/ya-salt'

ETC_HOSTMAN = '/etc/hostman'

FILE_DISABLE_RUN = os.path.join(RUN_DIR, 'disabled')  # Flag file for disable run
F_LOCK_FR = os.path.join(RUN_DIR, 'lock_file')
F_LOCK_EX = os.path.join(RUN_DIR, 'exec_lock_file')
LOG_FILE_DEFAULT = '/var/log/ya-salt.log'
LOG_FILE_HOSTCTL = '/var/log/hostctl.log'

INFO_FILE_PATH = '/etc/server_info.json'

STATUS_PATH = os.path.join(VAR_LIB, 'hm-status.pb')
SPEC_PATH = os.path.join(VAR_LIB, 'hm-spec.pb')
# Keep in sync with postinst/main.go

INITIAL_SETUP_MARKER = os.path.join(VAR_LIB, '__need_initial_setup__')

LOCAL_REPO_BASEDIR = os.path.join(VAR_LIB, 'repo')
LOCAL_REPO_CURRENT = os.path.join(LOCAL_REPO_BASEDIR, 'current')

REPO_OVERRIDE_DIR = os.path.join(ETC_HOSTMAN, 'repo-override')

GOLOVAN_TIMEOUT = 10.0
GOLOVAN_RETRY_LIMIT = 3
GOLOVAN_ITYPE = "runtimecloud"
GOLOVAN_CTYPE = "production"
GOLOVAN_TTL = 1800

GENCFG_REPO_PATH = 'search_runtime/_pillars/gencfg-version.sls'

RESOURCE_ROOT_CA_PATH = '/certs/YandexInternalRootCA.crt'

# Orly rule for salt execution
ORLY_SALT_RULE = 'salt-state-apply'
# Orly rule for salt on prestable execution
ORLY_SALT_RULE_PRESTABLE = 'salt-state-apply-prestable'
# Orly rule for salt execution when we need initial setup
ORLY_SALT_RULE_INITIAL = ORLY_SALT_RULE + '-initial'

# Special status indicating initial setup done, but host needs to be rebooted
AWAITING_REBOOT_STATUS = 'Awaiting reboot'

# Hostctl-based kernel constants
HOSTCTL_KERNEL_SPEC_PATH = '/var/lib/ya-salt/exec/kernel/kernel/hostctl.yaml'
HOSTCTL_KERNEL_FIELD = 'version'

# eth*|vlan* - xenial, en* - focal
NET_IFACE_RE = r'^((eth|vlan)[0-9]+|en.+)$'
