import infra.ya_salt.lib.policy


class ICtx(object):
    """ Advisory execution controller """

    def done(self):
        """
        :rtype: bool
        """
        raise NotImplementedError

    def error(self):
        """
        :rtype: unicode
        """
        raise NotImplementedError

    def fail(self, name, err):
        """
        Register task failure

        :rtype: None
        """
        raise NotImplementedError

    def ok(self, name):
        """
        Register task success

        :rtype: None
        """
        raise NotImplementedError


class Ctx(ICtx):
    def __init__(self, policy=None):
        self._done = False
        self._err = ''
        self._policy = policy or infra.ya_salt.lib.policy.FailPermissive()

    def done(self):
        return self._done

    def error(self):
        return self._err

    def fail(self, name, err):
        if not self._done:
            self._policy.add_failure(name)
            if self._policy.is_violated():
                self._done = True
                self._err = 'execution policy violated: ' + err

    def ok(self, name):
        if not self._done:
            self._policy.add_success(name)
            if self._policy.is_violated():
                self._done = True
                self._err = 'execution policy violated'


class CallbackCtx(Ctx):
    """
    On every check to done will call callback until it cancels context.
    """

    def __init__(self, callback, *args, **kwargs):
        super(CallbackCtx, self).__init__(*args, **kwargs)
        self.callback = callback

    def done(self):
        if not self._done:
            self._done, self._err = self.callback()
        return self._done

    def error(self):
        return self._err
