"""
Gathers host information (a.k.a grains) for salt.
"""
import socket

from salt import loader

from infra.ya_salt.lib import walle

_GRAIN_LOADER_OPTS = {
    'enable_lspci': False,  # Do not query PCI devices
    'enable_gpu_grains': False,  # Do not query GPU
    'id': socket.gethostname(),
}


def load_grains():
    w, err = walle.grains(_GRAIN_LOADER_OPTS['id'])
    if err is not None:
        return None, err
    try:
        g = loader.grains(_GRAIN_LOADER_OPTS)
    except Exception as e:
        return None, str(e)
    g.update(w)
    return g, None


def load_core_grains():
    try:
        from salt.grains import core
        core.__opts__ = _GRAIN_LOADER_OPTS
        return core.os_data(), None
    except Exception as e:
        return None, str(e)
