import json
import socket
import time

import requests
from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry

TIMEOUT = 5.0
RETRY_LIMIT = 3


class Check(object):
    @classmethod
    def make_walle(cls, service, status, reason, tags=None):
        d = {
            'timestamp': time.time(),
            'reason': reason,
        }
        return cls(service, status, desc=json.dumps(d), tags=tags)

    def __init__(self, service, status, desc=None, tags=None):
        self.service = service
        self.status = status
        self.desc = desc
        self.tags = tags or []

    def to_event(self, hostname):
        return {
            "host": hostname,
            "service": self.service,
            "instance": "",
            "status": self.status,
            "description": self.desc,
            "tags": self.tags,
        }


def push(checks):
    h = socket.gethostname()
    req = {
        "events": [c.to_event(h) for c in checks]
    }
    try:
        with requests.Session() as s:
            s.trust_env = False  # Do not use .netrc
            retries = Retry(
                total=RETRY_LIMIT,
                read=RETRY_LIMIT,
                connect=RETRY_LIMIT,
                backoff_factor=0.5,
                status_forcelist=[500, 502, 503, 504],
                method_whitelist=frozenset(['POST'])
            )
            s.mount('http://', HTTPAdapter(max_retries=retries))
            r = s.post("http://[::1]:31579/events", json=req, timeout=TIMEOUT)
    except Exception as e:
        return 'juggler request failed: {}'.format(e)
    if r.status_code != 200:
        return "juggler http response code: {}".format(r.status_code)
    return None
