from . import netutil

from infra.netconfig.lib import lldputil


class LldpInfo(object):
    @classmethod
    def from_dict(cls, d):
        return cls(d['switch_name'], d['port_name'])

    def __init__(self, sysname, port):
        self.sysname = sysname
        self.port = port


def recv_lldp():
    ifname, err = netutil.backbone_ifname()
    if err is not None:
        return None, 'failed to find backbone ifname: {}'.format(err)
    try:
        d = lldputil.parse_lldp_packet(ifname)
    except Exception as e:
        return None, 'failed to listen and parse LLDP: {}'.format(e)
    if not d.get('switch_name'):
        return None, 'no/empty switch name in LLDP'
    if not d.get('port_name'):
        return None, 'no/empty port name in LLDP'
    return LldpInfo.from_dict(d), None
