import logging
import sys

LOG_FORMAT = '%(asctime)s - %(name)s - %(levelname)s - %(message)s'
TERM_FORMAT = '%(asctime)s [%(levelname)s] %(message)s'


def _silence():
    # Silence requests excessive debug logging
    logging.getLogger('urllib3.connectionpool').setLevel(logging.ERROR)
    # Silence salt excessive debug logging
    logging.getLogger('salt.template').setLevel(logging.INFO)
    logging.getLogger('salt.fileclient').setLevel(logging.INFO)


def basic_config(level=logging.ERROR):
    """
    Basic logging config before we have parsed command line and read config file.
    """
    # Salt messes with logging during import, remove everything.
    del logging.getLogger().handlers[:]
    logging.basicConfig(level=level, format=LOG_FORMAT)
    _silence()


def setup_logging(level, file_path, console=False):
    """
    Reset logging configuration after config file and command line processed.
    """
    root = logging.getLogger()
    root.setLevel(level)

    handler = logging.FileHandler(file_path)
    handler.setFormatter(logging.Formatter(LOG_FORMAT))
    if not console:  # Remove console output, if not enforced
        del root.handlers[:]
    else:
        root.handlers[0].setLevel(level)
    _silence()
    root.addHandler(handler)


def setup_terminal(level=logging.INFO):
    """
    Set's up logger suitable for interactive sessions
    """
    root = logging.getLogger()
    del root.handlers[:]
    root.setLevel(level)
    handler = logging.StreamHandler(sys.stderr)
    handler.setFormatter(logging.Formatter(TERM_FORMAT))
    _silence()
    root.addHandler(handler)
