"""
O'RLY client closed under current host name.
"""
from infra.orly import client
from infra.orly.proto import orly_pb2


class Orly(object):
    def __init__(self, hostname, labels, url):
        self.hostname = hostname
        self.labels = labels
        self.orly = client.Orly(url or client.Orly.PROD_URL)

    def start_operation(self, rule_id):
        m = orly_pb2.OperationRequest()
        m.rule = rule_id
        m.id = self.hostname
        m.labels.update(self.labels)
        resp, status = self.orly.start_operation(m)
        if status is not None:
            return "operation on {} failed: {}".format(rule_id, status.message)
        return None
