import io


class ColorOutput(object):
    def __init__(self):
        self.buf = io.BytesIO()
        self.indent = b''
        # Default colors
        self.colors = {
            'header': b'\033[95m',
            'blue': b'\033[94m',
            'green': b'\033[32m',
            'orange': b'\033[33m',
            'red': b'\033[91m',
            'end': b'\033[0m',
            'bold': b'\033[1m',
            'underline': b'\033[4m'
        }

    def set_colors(self, d):
        if 'end' not in d:
            d['end'] = b''
        self.colors = d

    def c(self, w, word, color, bold=False, underline=False):
        if bold:
            w(self.colors.get('bold', b''))
        if underline:
            w(self.colors.get('underline', b''))
        if color in self.colors:
            w(self.colors[color])
        w(word)
        w(self.colors['end'])

    def write(self, message, def_color="end"):
        if isinstance(message, unicode):
            message = message.encode('utf-8')
        self.buf.write(self.indent)
        self.c(self.buf.write, message, def_color)
        self.buf.write(b'\n')

    def add_n(self, count=1):
        self.buf.write(b'\n' * count)

    def set_indent(self, count=1):
        self.indent = b' ' * count

    def __str__(self):
        return self.buf.getvalue()


class NoColorOutput(ColorOutput):
    def __init__(self):
        super(NoColorOutput, self).__init__()
        self.set_colors({})
