class Install(object):
    __slots__ = ('name', 'version', 'src')

    def __init__(self, name, version, src):
        self.version = version
        self.name = name
        self.src = src

    def __repr__(self):
        return 'Install("{}"="{}", src: "{}")'.format(
            self.name, self.version, self.src
        )

    def __str__(self):
        return self.__repr__()


class Remove(object):
    __slots__ = ('name', 'src')

    def __init__(self, name, src):
        self.name = name
        self.src = src

    def __repr__(self):
        return 'Remove("{}", src: "{}")'.format(
            self.name, self.src
        )

    def __str__(self):
        return self.__repr__()
