import logging

from infra.ya_salt.lib.packages import action

log = logging.getLogger(__name__)

INSTALL = 'installed'
PURGE = 'purged'
REMOVE = 'removed'
REMOVED_STATES = [PURGE, REMOVE]


def lo_to_action(state):
    if state.get('state') == 'pkg':
        act = state.get('fun')
        if act == INSTALL:
            if 'pkgs' in state:
                for pkg in state['pkgs']:
                    pkg_name, ver = _get_pkg_ver_from_lo(pkg)
                    yield action.Install(pkg_name, ver, fmt_src_from_lo(state))
            else:
                yield action.Install(state.get('name'),
                                     state.get('version'),
                                     fmt_src_from_lo(state))
        elif act in REMOVED_STATES:
            if 'pkgs' in state:
                for pkg in state['pkgs']:
                    yield action.Remove(pkg, fmt_src_from_lo(state))
            else:
                yield action.Remove(state.get('name'), fmt_src_from_lo(state))
        else:
            log.warn('got pkg state "{}" from "{}" with unexpected func "{}"'.format(
                state.get('__id__'), state.get('__sls__'), state.get('fun')
            ))


def extract_lo_packages_to_tx(lo, tx):
    for state in lo:
        for act in lo_to_action(state):
            if isinstance(act, action.Install):
                tx.installed(act)
            elif isinstance(act, action.Remove):
                tx.removed(act)


def extract_lo_package_actions(lo):
    installed, removed = [], []
    for state in lo:
        for act in lo_to_action(state):
            if isinstance(act, action.Install):
                installed.append(act)
            elif isinstance(act, action.Remove):
                removed.append(act)
    return installed, removed


def _get_pkg_ver_from_lo(lo_pkg):
    if isinstance(lo_pkg, basestring):
        return lo_pkg, None
    else:
        return lo_pkg.items()[0]


def fmt_src_from_lo(state):
    return 'sls:{}->{}'.format(state.get('__sls__'), state.get('__id__'))


def add_packages_from_component(tx, component):
    installed, removed = component.get_packages_actions()
    for act in installed:
        tx.installed(act)
    for act in removed:
        tx.removed(act)
