import collections
import logging

log = logging.getLogger(__name__)

KERNEL_PACKAGE_NAME = 'linux-image-server'


class Transaction(object):
    def __init__(self):
        self._installed = collections.defaultdict(list)
        self._removed = collections.defaultdict(list)

    def installed(self, pkg):
        self._installed[pkg.name].append(pkg)

    def removed(self, pkg):
        self._removed[pkg.name].append(pkg)

    def get_installed(self):
        return self._installed

    def get_removed(self):
        return self._removed


def get_pkg_installed_version(pkg, tx):
    """
    get installed package version from transaction
    :param pkg: package name
    :param tx: transaction
    :return: (version, error)
    """
    installed_packages = tx.get_installed()
    if pkg not in installed_packages:
        return None, 'package "{}" is not scheduled to be installed'.format(pkg)
    # in valid state there should be exactly one version
    return installed_packages[pkg][0].version, None
