import logging

log = logging.getLogger('validator')


def validate_packages_loop(tx):
    messages = []
    installed = set(tx.get_installed())
    removed = set(tx.get_removed())
    installed_and_removed = installed & removed
    if installed_and_removed:
        for p in installed_and_removed:
            messages.append('install-remove loop detected for package "{}" - {}'.format(
                p, ', '.join(str(pk) for pk in tx.get_removed()[p] + tx.get_installed()[p])
            ))
    for pkgs in tx.get_removed().values():
        if len(pkgs) > 1:
            log.warn('package removal defined multiple times: {}'.format(', '.join(str(pk) for pk in pkgs)))
    return messages


def validate_packages_versions_loop(tx):
    messages = []
    for pkg, pkgs in tx.get_installed().items():
        if len(pkgs) > 1:
            log.warn('package {} has multiple install statements'.format(', '.join(str(pk) for pk in pkgs)))
        versions = {p.version for p in pkgs}
        if len(versions) > 1:
            messages.append('version loop detected for package "{}" - {}'.format(
                pkg, ', '.join(str(pk) for pk in pkgs)
            ))
    return messages


def validate_packages_versions_present(tx):
    messages = []
    for pkgs in tx.get_installed().values():
        for p in pkgs:
            if p.version is None or p.version == '':
                messages.append('package action {} has no version'.format(p))
    return messages


def validate_transaction(tx):
    messages = []
    messages.extend(validate_packages_versions_present(tx))
    messages.extend(validate_packages_loop(tx))
    messages.extend(validate_packages_versions_loop(tx))
    return messages
