class IPolicy(object):
    """ Execution policy interface """

    def add_failure(self, name):
        """ Register failure """
        raise NotImplementedError

    def add_success(self, name):
        """ Register success """
        raise NotImplementedError

    def is_violated(self):
        """ Check policy violation """
        raise NotImplementedError


class FailPermissive(IPolicy):
    def add_failure(self, name):
        pass

    def add_success(self, name):
        pass

    def is_violated(self):
        return False


class FailFast(IPolicy):
    def __init__(self):
        self.__violated = False

    def add_failure(self, name):
        self.__violated = True

    def add_success(self, name):
        pass

    def is_violated(self):
        return self.__violated
