"""
Power manager. Knows how to reboot.
"""
import time
from infra.ya_salt.lib import subprocutil


class PowerManager(object):
    REBOOT_CMD = ['/sbin/reboot']
    REBOOT_TIMEOUT = 180

    def __init__(self, check_output=subprocutil.check_output):
        self.check_output = check_output

    def reboot(self, timeout=REBOOT_TIMEOUT):
        status = self.check_output(self.REBOOT_CMD, timeout=timeout)[2]
        if not status.ok:
            return 'failed to reboot: {}'.format(status.message)
        time.sleep(timeout)
        return 'failed to reboot in {} seconds'.format(timeout)
