import logging

log = logging.getLogger('reporter')


class ReportManager(object):
    """
    :type reporters: list[infra.ya_salt.lib.reporters.iface.IReporter]
    """
    def __init__(self):
        self.reporters = []

    def register(self, r):
        self.reporters.append(r)

    def notify(self, status):
        errors = []
        for reporter in self.reporters:
            name = reporter.__class__.__name__.lower()
            try:
                reporter.notify(status)
            except Exception as e:
                log.exception('')
                errors.append("Reporter '{}' failed: {}".format(name, e))
        return errors
