import resource

METRIC_RUSAGE_UTIME_SEC = 'hostman-rusage-utime_thhh'
METRIC_RUSAGE_STIME_SEC = 'hostman-rusage-stime_thhh'
METRIC_RUSAGE_MAXRSS_MB = 'hostman-rusage-maxrss_thhh'


def get_rusage_metrics():
    self = resource.getrusage(resource.RUSAGE_SELF)
    ch = resource.getrusage(resource.RUSAGE_CHILDREN)
    return [
        (METRIC_RUSAGE_UTIME_SEC, self.ru_utime + ch.ru_utime),
        (METRIC_RUSAGE_STIME_SEC, self.ru_stime + ch.ru_stime),
        (METRIC_RUSAGE_MAXRSS_MB, max(self.ru_maxrss, ch.ru_maxrss) / 1024),
    ]
