import collections


def get_executed_states_count(salt_components):
    return sum(len(c.salt.state_results) for c in salt_components)


def get_executed_states_results_by_component(salt_components):
    ok = collections.defaultdict(int)
    ch = collections.defaultdict(int)
    fail = collections.defaultdict(int)
    for c in salt_components:
        if c.skip_reporting:
            continue
        for r in c.salt.state_results:
            ok[c.name] += 1 if r.ok else 0
            ch[c.name] += 1 if r.changes else 0
            fail[c.name] += 0 if r.ok else 1
    return ok, ch, fail


def has_failed_executed_states(salt_components):
    for c in salt_components:
        for r in c.salt.state_results:
            if not r.ok:
                return True
    return False


def get_executed_states_results(salt_components,
                                ok_filter=lambda r: True,
                                changed_filter=lambda r: True,
                                fail_filter=lambda r: True):
    ok = 0
    fail = 0
    changed = 0
    for c in salt_components:
        for s in c.salt.state_results:
            if s.ok and ok_filter(s):
                ok += 1
            elif fail_filter(s):
                fail += 1
            if s.changes and changed_filter(s):
                changed += 1
    return ok, changed, fail


def failed_components_names(salt_components):
    failed = []
    for c in salt_components:
        for s in c.salt.state_results:
            if not s.ok:
                failed.append(s.id)
    return failed


def enumerate_executed_states(salt_components, result_fn):
    for c in salt_components:
        for s in c.salt.state_results:
            result_fn(s)


def enumerate_executed_components(salt_components, component_fn):
    for c in salt_components:
        component_fn(c)
