import logging

import requests
from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry

from infra.ya_salt.lib import constants

log = logging.getLogger('yasm-client')


def make_body(signal_values, tags=None, use_ttl=True):
    values = []
    signals = {
        "tags": {
            "itype": constants.GOLOVAN_ITYPE,
            "ctype": constants.GOLOVAN_CTYPE,
        },
        "values": values,
    }
    if use_ttl:
        signals["ttl"] = constants.GOLOVAN_TTL
        log.debug('Golovan TTL signals {}'.format(signals['ttl']))
    if tags:
        for k, v in tags.iteritems():
            signals['tags'][k] = v
    log.debug('Golovan tags {}'.format(signals['tags']))
    for name, value in signal_values:
        log.debug('Signal "{}" value "{}"'.format(name, value))
        values.append(
            {
                "name": name,
                "val": value,
            }
        )
    return [signals]


def push_local(signal_values, tags=None, use_ttl=True):
    signals = make_body(signal_values, tags, use_ttl)
    retries = Retry(
        total=constants.GOLOVAN_RETRY_LIMIT,
        read=constants.GOLOVAN_RETRY_LIMIT,
        connect=constants.GOLOVAN_RETRY_LIMIT,
        backoff_factor=0.5,
        status_forcelist=[500, 502, 503, 504],
        method_whitelist=frozenset(['POST'])
    )
    try:
        with requests.Session() as s:
            s.trust_env = False  # Do not use .netrc
            s.mount('http://', HTTPAdapter(max_retries=retries))
            r = s.post("http://[::1]:11005/", json=signals, timeout=constants.GOLOVAN_TIMEOUT)
            data = r.json()
    except Exception as e:
        return "exception in request to golovan. Exception '{}'".format(e)
    if r.status_code != 200:
        return "yasm http response code: {}; text: {}".format(r.status_code, r.text)
    if data['status'] == 'ok':
        return None
    return "yasm response status: {}".format(data)
