package main

import (
	"os"
	"testing"
)

const testPath = "path/to/__test__initial_setup__"

func TestMakeMarker(t *testing.T) {
	err := makeMarker(testPath)
	if err != nil {
		t.Fatal(err)
	}
	st, err := os.Stat(testPath)
	_ = os.RemoveAll("path")
	if os.IsNotExist(err) {
		t.Fatal("No test file created")
	}
	if st.Mode() != 0644 {
		t.Fatalf("Wrong file mode: %#o", st.Mode())
	}

}

func TestContains(t *testing.T) {
	haystack := []string{
		"a",
		"ab",
		"c",
	}
	if contains(haystack, "d") {
		t.Error("Found d")
	}
	if !contains(haystack, "ab") {
		t.Error("Not found d")
	}
	// Corner case
	haystack = []string{}
	if contains(haystack, "d") {
		t.Error("Found d in empty haystack")
	}
}
