import os
import logging
import subprocess

from infra.ya_salt.lib import subprocutil

log = logging.getLogger(__name__)


def _extract_switch_port(ifnames):
    rv = []
    try:
        buf = subprocess.check_output(['/usr/sbin/lldpctl', '-f', 'keyvalue'],
                                      preexec_fn=subprocutil.set_pdeath_sig)
    except Exception, e:
        log.error('lldpctl: {}'.format(e))
        return []
    output = buf.split('\n')
    for eth in ifnames:
        sw_line = 'lldp.{}.chassis.name'.format(eth)
        pt_line = 'lldp.{}.port.ifname'.format(eth)
        switch = None
        port = None
        for line in output:
            if line.startswith(sw_line):
                split_line = line.split('=')
                switch = split_line[1]
            if line.startswith(pt_line):
                split_line = line.split('=')
                port = split_line[1]
        if switch and port:
            rv.append({'switch': switch, 'port': port})
        else:
            log.error('failed to parse switch/port from lldp for {}:\n'
                      '{}'.format(eth, buf))
    return rv


def _get_int_state(ifname):
    path = '/sys/class/net/{}/operstate'.format(ifname)
    try:
        with open(path) as f:
            return f.read().strip()
    except IOError, e:
        log.error('IOError[{}] {}: {}'.format(e.errno, e.strerror, e.filename))
        return 'down'


def _list_ifnames():
    rv = []
    try:
        ifnames = os.listdir('/sys/class/net/')
    except Exception as e:
        log.error('listdir() failed: {}'.format(e))
        return []
    for ifname in ifnames:
        if ifname.startswith('eth') and _get_int_state(ifname) == 'up':
            rv.append(ifname)
    return rv


def lldp():
    logging.info('Starting lldp grains')
    ifnames = _list_ifnames()
    return {"lldp": _extract_switch_port(ifnames)}
