#include "containers.h"

using namespace NAgent::NPlayer;

namespace {
    static constexpr TDuration PLAYER_DATA_TTL = TDuration::Seconds(5 * 2);
}

TPlayerDataContainer::TPlayerDataContainer()
    : StartTime(TInstant::Now())
    , EmptyPlayerData(MakeAtomicShared<TPlayerData>())
{
}

TInstant TPlayerDataContainer::GetStartTime() const {
    return StartTime;
}

TAtomicSharedPtr<TPlayerData> TPlayerDataContainer::CheckAndGet(TInstant now) const {
    TGuard<TAdaptiveLock> guard{Lock};
    auto result(CurrentPlayerData);
    if (result && result->GetTimestamp() + PLAYER_DATA_TTL > now) {
        return result;
    } else {
        return EmptyPlayerData;
    }
}

TAtomicSharedPtr<TPlayerData> TPlayerDataContainer::CheckAndGet() const {
    return CheckAndGet(TInstant::Now());
}

void TPlayerDataContainer::Set(TAtomicSharedPtr<TPlayerData> data) {
    TGuard<TAdaptiveLock> guard{Lock};
    CurrentPlayerData.Swap(data);
}
