#pragma once

#include "types.h"

#include <util/system/spinlock.h>

namespace NAgent::NPlayer {
    class TPlayerDataContainer {
    public:
        TPlayerDataContainer();

        TInstant GetStartTime() const;
        TAtomicSharedPtr<TPlayerData> CheckAndGet(TInstant now) const;
        TAtomicSharedPtr<TPlayerData> CheckAndGet() const;
        void Set(TAtomicSharedPtr<TPlayerData> data);

    private:
        const TInstant StartTime;
        TAtomicSharedPtr<TPlayerData> CurrentPlayerData;
        TAtomicSharedPtr<TPlayerData> EmptyPlayerData;
        TAdaptiveLock Lock;
    };

    struct TVersionContainer {
        const TString Version;
    };
}
