#include "containers.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NAgent::NPlayer;

Y_UNIT_TEST_SUITE(TPlayerDataContainerTest) {
    Y_UNIT_TEST(TestAccess) {
        TPlayerDataContainer container;
        UNIT_ASSERT(container.CheckAndGet(TInstant::Seconds(1000))->Empty());

        container.Set(MakeAtomicShared<TPlayerData>());
        UNIT_ASSERT(container.CheckAndGet(TInstant::Seconds(1000))->Empty());

        container.Set(MakeAtomicShared<TPlayerData>(TInstant::Seconds(1000), TVector<TPerInstanceData>(), TVector<TAggregatedData>()));
        UNIT_ASSERT_VALUES_EQUAL(container.CheckAndGet(TInstant::Seconds(1000))->GetTimestamp(), TInstant::Seconds(1000));
        UNIT_ASSERT(container.CheckAndGet(TInstant::Seconds(1010))->Empty());

        container.Set(MakeAtomicShared<TPlayerData>(TInstant::Seconds(1010), TVector<TPerInstanceData>(), TVector<TAggregatedData>()));
        UNIT_ASSERT_VALUES_EQUAL(container.CheckAndGet(TInstant::Seconds(1010))->GetTimestamp(), TInstant::Seconds(1010));
    }
}
