# coding: utf-8

from util.generic.string cimport TString
from util.datetime.base cimport TDuration

from infra.yasm.agent.player.container.types cimport TPlayerData


cdef extern from "library/cpp/http/server/options.h" nogil:
    cdef cppclass THttpServerOptions:
        THttpServerOptions()

        THttpServerOptions& AddBindAddress(const TString& address, int port) except +
        THttpServerOptions& SetThreads(int threads)
        THttpServerOptions& SetMaxConnections(int conn)
        THttpServerOptions& SetClientTimeout(const TDuration& timeout)
        THttpServerOptions& SetListenBacklog(int val)


cdef extern from "infra/yasm/agent/player/container/handlers.h" namespace "NAgent::NPlayer" nogil:
    cdef cppclass TPlayer:
        TPlayer(const THttpServerOptions& serverOptions, const TString& version, const TString& log_dir) except +

        void SetPlayerData(TPlayerData* playerData) except +

        void Run() except +
        void Stop() except +
