#pragma once

#include "types.h"

#include <Python.h>

namespace NAgent::NPlayer {
    class TPlayerDataParser {
    public:
        static TPlayerData* Deserialize(TInstant timestamp, PyObject* perInstanceData, PyObject* aggregatedData);

    private:
        static TPerInstanceData DeserializePerInstanceData(const TString& instanceName, PyObject* data);
        static TAggregatedData DeserializeAggregatedData(PyObject* data);

        static TVector<TPerInstanceData> DeserializePerInstanceDataList(PyObject* root);
        static TVector<TAggregatedData> DeserializeAggregatedDataList(PyObject* root);
        static TVector<NTags::TInstanceKey> DeserializeTags(PyObject* root);
    };
}
