#pragma once

#include "types.h"

#include <infra/yasm/zoom/components/serialization/zoom_to_json/zoom_to_json.h>
#include <infra/yasm/zoom/components/serialization/zoom_to_msgpack/zoom_to_msgpack.h>
#include <infra/yasm/interfaces/internal/agent.pb.h>

#include <library/cpp/json/writer/json.h>

#include <contrib/libs/msgpack/include/msgpack.hpp>

namespace NAgent::NPlayer {
    class TPlayerDataSerializer {
    public:
        TPlayerDataSerializer(const TPlayerData& playerData)
            : PlayerData(playerData)
        {
        }

        void ToPerInstanceJson(NJsonWriter::TBuf& jsonBuf);
        static TString ToPerInstanceJson(const TPlayerData& playerData);

        void ToAggregatedJson(NJsonWriter::TBuf& jsonBuf);
        static TString ToAggregatedJson(const TPlayerData& playerData);

        void ToPerInstanceMsgpack(msgpack::packer<msgpack::sbuffer>& packer);
        static TString ToPerInstanceMsgpack(const TPlayerData& playerData);

        void ToAggregatedMsgpack(msgpack::packer<msgpack::sbuffer>& packer);
        static TString ToAggregatedMsgpack(const TPlayerData& playerData);

        void ToPerInstanceProtobuf(NYasm::NInterfaces::NInternal::TPerInstanceRecords& records);
        static TString ToPerInstanceProtobuf(const TPlayerData& playerData);

        void ToAggregatedProtobuf(NYasm::NInterfaces::NInternal::TAggregatedRecords& records);
        static TString ToAggregatedProtobuf(const TPlayerData& playerData);

    private:
        const TPlayerData& PlayerData;
    };
}
