#include "types.h"

using namespace NAgent::NPlayer;

TPerInstanceData::TPerInstanceData(const TString& instanceName, const TString& instanceType, const TString& hostName,
                                   TVector<NTags::TInstanceKey>&& tags, NZoom::NRecord::TRecord&& record)
    : InstanceName(instanceName)
    , InstanceType(instanceType)
    , HostName(hostName)
    , Tags(std::move(tags))
    , Record(std::move(record))
{
}

const TString& TPerInstanceData::GetName() const {
    return InstanceName;
}

const TString& TPerInstanceData::GetItype() const {
    return InstanceType;
}

const TString& TPerInstanceData::GetHostName() const {
    return HostName;
}

const TVector<NTags::TInstanceKey>& TPerInstanceData::GetTags() const {
    return Tags;
}

const NZoom::NRecord::TRecord& TPerInstanceData::GetRecord() const {
    return Record;
}

TAggregatedData::TAggregatedData(const TString& itype, const TString& tail, NZoom::NRecord::TRecord&& record)
    : InstanceType(itype)
    , InstanceTail(tail)
    , Record(std::move(record))
{
}

const TString& TAggregatedData::GetItype() const {
    return InstanceType;
}

const TString& TAggregatedData::GetTail() const {
    return InstanceTail;
}

const NZoom::NRecord::TRecord& TAggregatedData::GetRecord() const {
    return Record;
}

NTags::TInstanceKey TAggregatedData::GetInstanceKey() const {
    return NTags::TInstanceKey::FromAgent(GetItype(), GetTail());
}

TPlayerData::TPlayerData()
    : TPlayerData(TInstant::Zero(), TVector<TPerInstanceData>(), TVector<TAggregatedData>())
{
}

TPlayerData::TPlayerData(TInstant timestamp, TVector<TPerInstanceData> perInstance, TVector<TAggregatedData> aggregated)
    : Timestamp(timestamp)
    , PerInstance(std::move(perInstance))
    , Aggregated(std::move(aggregated))
{
}

TInstant TPlayerData::GetTimestamp() const {
    return Timestamp;
}

const TVector<TPerInstanceData>& TPlayerData::GetPerInstance() const {
    return PerInstance;
}

const TVector<TAggregatedData>& TPlayerData::GetAggregated() const {
    return Aggregated;
}

bool TPlayerData::Empty() const {
    return Timestamp == TInstant::Zero();
}
