#pragma once

#include <infra/yasm/common/labels/tags/instance_key.h>
#include <infra/yasm/zoom/components/record/record.h>

#include <util/datetime/base.h>

namespace NAgent::NPlayer {
    class TPerInstanceData : public TMoveOnly {
    public:
        TPerInstanceData(const TString& instanceName, const TString& instanceType, const TString& hostName,
                         TVector<NTags::TInstanceKey>&& tags, NZoom::NRecord::TRecord&& record);

        const TString& GetName() const;
        const TString& GetItype() const;
        const TString& GetHostName() const;
        const TVector<NTags::TInstanceKey>& GetTags() const;
        const NZoom::NRecord::TRecord& GetRecord() const;

    private:
        TString InstanceName;
        TString InstanceType;
        TString HostName;
        TVector<NTags::TInstanceKey> Tags;
        NZoom::NRecord::TRecord Record;
    };

    class TAggregatedData : public TMoveOnly {
    public:
        TAggregatedData(const TString& itype, const TString& tail, NZoom::NRecord::TRecord&& record);

        const TString& GetItype() const;
        const TString& GetTail() const;
        const NZoom::NRecord::TRecord& GetRecord() const;
        NTags::TInstanceKey GetInstanceKey() const;

    private:
        TString InstanceType;
        TString InstanceTail;
        NZoom::NRecord::TRecord Record;
    };

    class TPlayerData : public TMoveOnly {
    public:
        TPlayerData();
        TPlayerData(TInstant timestamp, TVector<TPerInstanceData> perInstance, TVector<TAggregatedData> aggregated);

        TInstant GetTimestamp() const;
        const TVector<TPerInstanceData>& GetPerInstance() const;
        const TVector<TAggregatedData>& GetAggregated() const;
        bool Empty() const;

    private:
        TInstant Timestamp;
        TVector<TPerInstanceData> PerInstance;
        TVector<TAggregatedData> Aggregated;
    };
}
