# coding: utf-8

from cpython cimport PyObject

from util.generic.string cimport TString
from util.datetime.base cimport TInstant, TDuration

from infra.yasm.agent.player.container.types cimport TPlayerData
from infra.yasm.agent.player.container.parser cimport TPlayerDataParser
from infra.yasm.agent.player.container.serializers cimport TPlayerDataSerializer
from infra.yasm.agent.player.container.handlers cimport THttpServerOptions, TPlayer

__doc__ = "Player speedups"


cdef class ZPlayerData:
    cdef TPlayerData* data

    def __cinit__(self, timestamp, per_instance_data, aggregated_data):
        cdef TInstant c_timestamp = TInstant.Seconds(timestamp)
        self.data = TPlayerDataParser.Deserialize(c_timestamp, <PyObject*>per_instance_data, <PyObject*>aggregated_data)

    def __dealloc__(self):
        if self.data != NULL:
            del self.data

    def to_per_instance_json(self):
        return TPlayerDataSerializer.ToPerInstanceJson(self.data[0])

    def to_aggregated_json(self):
        return TPlayerDataSerializer.ToAggregatedJson(self.data[0])

    def to_per_instance_msgpack(self):
        return TPlayerDataSerializer.ToPerInstanceMsgpack(self.data[0])

    def to_aggregated_msgpack(self):
        return TPlayerDataSerializer.ToAggregatedMsgpack(self.data[0])

    def to_per_instance_protobuf(self):
        return TPlayerDataSerializer.ToPerInstanceProtobuf(self.data[0])

    def to_aggregated_protobuf(self):
        return TPlayerDataSerializer.ToAggregatedProtobuf(self.data[0])


cdef class ZHttpServerOptions:
    cdef THttpServerOptions options

    def add_bind_address(self, address, port):
        self.options.AddBindAddress(address, port)

    def set_threads(self, threads):
        self.options.SetThreads(threads)

    def set_max_connections(self, conn):
        self.options.SetMaxConnections(conn)

    def set_client_timeout(self, timeout):
        self.options.SetClientTimeout(TDuration.MicroSeconds(timeout * 10**6))

    def set_listen_backlog(self, backlog):
        self.options.SetListenBacklog(backlog)


cdef class ZPlayer:
    cdef TPlayer* player

    def __cinit__(self, ZHttpServerOptions http_options, version, log_dir):
        self.player = new TPlayer(http_options.options, version, log_dir)

    def __dealloc__(self):
        del self.player

    def set_player_data(self, ZPlayerData player_data):
        self.player[0].SetPlayerData(player_data.data)
        player_data.data = NULL

    def run(self):
        with nogil:
            self.player[0].Run()

    def stop(self):
        with nogil:
            self.player[0].Stop()
