#pragma once

#include "inferred_types.h"

#include <util/generic/ptr.h>
#include <util/generic/vector.h>
#include <util/generic/noncopyable.h>

namespace NYasm::NAldan {
    class TNode;

    class TNodeVisitor {
    public:
        virtual ~TNodeVisitor() = default;

        virtual void EnterNode(const TNode&) {
        }

        virtual void EnterNode(TNode&) {
        }

        virtual void VisitInteger(i64) {
        }

        virtual void VisitDouble(double) {
        }

        virtual void VisitIdent(const TString&) {
        }

        virtual void VisitApply(const TString&) {
        }

        virtual void FinishNode() {
        }
    };

    class TNode : public TNonCopyable {
    public:
        virtual ~TNode() = default;

        virtual void Visit(TNodeVisitor&) const = 0;

        virtual void Transform(TNodeVisitor&) = 0;

        virtual void AddChild(THolder<TNode>);

        TTypeConstructor::TPtr GetInferredType() const;
        void SetDefinition(TDefinition::TPtr definition);

        TString ToString() const;

    private:
        TDefinition::TPtr Definition;
    };
}
