#pragma once

#include <util/generic/yexception.h>

namespace NYasm::NAldan {
    class TAldanError : public yexception {
    };

    class TParsingError : public TAldanError {
    };

    class TInferError : public TAldanError {
    };

    class TUnifyError : public TInferError {
    };

    class TSymbolNotFound : public TInferError {
    public:
        TSymbolNotFound(const TString& symbolName)
            : SymbolName(symbolName)
        {
        }

    private:
        TString SymbolName;
    };

    class TExecutionError : public TAldanError {
    };
}

