#pragma once

#include <util/generic/ptr.h>
#include <util/system/yassert.h>

namespace NYasm::NAldan {
    template <class TBase>
    class TCastingMixin : public TAtomicRefCount<TBase> {
    public:
        virtual ~TCastingMixin() = default;

        template <typename D>
        D& CastUnsafe() noexcept {
            static_assert(
                std::is_base_of<TBase, D>::value,
                "T must be a descendant of TBase"
            );
            return *dynamic_cast<D*>(this);
        }

        template <typename D>
        const D& CastUnsafe() const noexcept {
            static_assert(
                std::is_base_of<TBase, D>::value,
                "T must be a descendant of TBase"
            );
            return *dynamic_cast<const D*>(this);
        }
    };
}
