#pragma once

#include "helpers.h"

namespace NYasm::NAldan {
    class TTypeConstructor : public TCastingMixin<TTypeConstructor> {
    public:
        using TPtr = TIntrusivePtr<TTypeConstructor>;

        enum EType {
            Variable,
            Operator,
            Function,
            Tuple,
            List
        };

        virtual EType GetType() const = 0;
        virtual TString ToString() const = 0;
        virtual size_t Hash() const = 0;
        virtual TTypeConstructor::TPtr Prune() = 0;
        virtual bool IsComposite() const = 0;

        inline bool operator==(const TTypeConstructor& other) const noexcept {
            return GetType() == other.GetType() && EqualUnsafe(other);
        }

        inline bool operator!=(const TTypeConstructor& other) const noexcept {
            return !(*this == other);
        }

    protected:
        virtual bool EqualUnsafe(const TTypeConstructor& other) const = 0;
    };

    class TDefinition : public TCastingMixin<TDefinition> {
    public:
        using TPtr = TIntrusivePtr<TDefinition>;

        enum EType {
            Lambda,
            Identifier,
            Apply,
            Let,
            Tuple,
            List
        };

        virtual EType GetType() const = 0;
        virtual TString ToString() const = 0;

        TTypeConstructor::TPtr GetInferredType() const {
            return InferredType;
        }

        void SetInferredType(TTypeConstructor::TPtr inferredType) {
            InferredType.Reset(std::move(inferredType));
        }

    private:
        TTypeConstructor::TPtr InferredType;
    };
}

template<>
struct THash<NYasm::NAldan::TTypeConstructor> {
    inline size_t operator()(const NYasm::NAldan::TTypeConstructor& v) const noexcept {
        return v.Hash();
    }
};
