#pragma once

#include "constructors.h"

#include <util/generic/hash_set.h>
#include <util/generic/hash.h>

namespace NYasm::NAldan {
    struct TTypeConstructorHash {
        inline size_t operator()(const TTypeConstructor::TPtr& constructor) const noexcept {
            return THash<TTypeConstructor>()(*constructor);
        }
    };

    struct TTypeConstructorEqualTo {
        inline bool operator()(const TTypeConstructor::TPtr& lhs, const TTypeConstructor::TPtr& rhs) const noexcept {
            return *lhs == *rhs;
        }
    };

    using TTypeConstructorSet = THashSet<TTypeConstructor::TPtr, TTypeConstructorHash, TTypeConstructorEqualTo>;

    template <class V>
    using TTypeConstructorMap = THashMap<TTypeConstructor::TPtr, V, TTypeConstructorHash, TTypeConstructorEqualTo>;
}
