#include "definitions.h"

#include <infra/yasm/aldan/common/exceptions.h>

#include <util/stream/output.h>
#include <util/string/builder.h>

using namespace NYasm::NAldan;

namespace {
    TString ArgumentsToString(const TVector<TDefinition::TPtr>& arguments) {
        TStringBuilder builder;
        bool first = true;
        for (const auto& argument : arguments) {
            if (!first) {
                builder << ", ";
            }
            builder << argument->ToString();
            first = false;
        }
        return TString(builder);
    }
}

TString TIdentifierDefinition::ToString() const {
    if (Name.empty()) {
        if (SuggestedType) {
            return SuggestedType->ToString();
        } else {
            ythrow TInferError() << "invalid identifier given";
        }
    } else {
        return Name;
    }
}

TString TApplyDefinition::ToString() const {
    return TString::Join(Function->ToString(), '(', Argument->ToString(), ')');
}

TString TLambdaDefinition::ToString() const {
    return TString::Join("(lambda ", Name, " => ", Body->ToString(), ')');
}

TString TLetDefinition::ToString() const {
    return TString::Join("(let ", Name, " = ", Definition->ToString(), " in ", Body->ToString(), ')');
}

TString TTupleDefinition::ToString() const {
    return TString::Join('(', ArgumentsToString(Arguments), ')');
}

TString TListDefinition::ToString() const {
    return TString::Join('[', ArgumentsToString(Arguments), ']');
}
