#pragma once

#include <infra/yasm/aldan/common/inferred_types.h>

#include <util/generic/ptr.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/generic/xrange.h>

namespace NYasm::NAldan {
    class TIdentifierDefinition : public TDefinition {
    public:
        static const EType Type = TDefinition::Identifier;

        TIdentifierDefinition(const TString& name)
            : Name(name)
        {
        }

        TIdentifierDefinition(TTypeConstructor::TPtr suggestedType)
            : SuggestedType(std::move(suggestedType))
        {
        }

        TIdentifierDefinition(const TString& name, TTypeConstructor::TPtr suggestedType)
            : Name(name)
            , SuggestedType(std::move(suggestedType))
        {
        }

        EType GetType() const override {
            return Type;
        }

        TString ToString() const override;

        const TString Name;
        const TTypeConstructor::TPtr SuggestedType;
    };

    class TApplyDefinition : public TDefinition {
    public:
        static const EType Type = TDefinition::Apply;

        TApplyDefinition(TDefinition::TPtr function, TDefinition::TPtr argument)
            : Function(std::move(function))
            , Argument(std::move(argument))
        {
        }

        EType GetType() const override {
            return Type;
        }

        TString ToString() const override;

        const TDefinition::TPtr Function;
        const TDefinition::TPtr Argument;
    };

    class TLambdaDefinition : public TDefinition {
    public:
        static const EType Type = TDefinition::Lambda;

        TLambdaDefinition(const TString& name, TDefinition::TPtr body)
            : Name(name)
            , Body(std::move(body))
        {
        }

        EType GetType() const override {
            return Type;
        }

        TString ToString() const override;

        const TString Name;
        const TDefinition::TPtr Body;
    };

    class TLetDefinition : public TDefinition {
    public:
        static const EType Type = TDefinition::Let;

        TLetDefinition(const TString& name, TDefinition::TPtr definition, TDefinition::TPtr body)
            : Name(name)
            , Definition(std::move(definition))
            , Body(std::move(body))
        {
        }

        EType GetType() const override {
            return Type;
        }

        TString ToString() const override;

        const TString Name;
        const TDefinition::TPtr Definition;
        const TDefinition::TPtr Body;
    };

    class TTupleDefinition : public TDefinition {
    public:
        static const EType Type = TDefinition::Tuple;

        TTupleDefinition(TVector<TDefinition::TPtr> arguments)
            : Arguments(std::move(arguments))
        {
        }

        EType GetType() const override {
            return Type;
        }

        TString ToString() const override;

        const TVector<TDefinition::TPtr> Arguments;
    };

    class TListDefinition : public TDefinition {
    public:
        static const EType Type = TDefinition::List;

        TListDefinition(TVector<TDefinition::TPtr> arguments)
            : Arguments(std::move(arguments))
        {
        }

        EType GetType() const override {
            return Type;
        }

        TString ToString() const override;

        const TVector<TDefinition::TPtr> Arguments;
    };
}
