#include "infer.h"
#include "builtin_types.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace NYasm::NAldan;

Y_UNIT_TEST_SUITE(TAldanInferTest) {

    Y_UNIT_TEST(TestPair) {
        auto pairNode = MakeIntrusive<TApplyDefinition>(
            MakeIntrusive<TApplyDefinition>(
                MakeIntrusive<TIdentifierDefinition>("pair"),
                MakeIntrusive<TApplyDefinition>(
                    MakeIntrusive<TIdentifierDefinition>("f"),
                    MakeIntrusive<TIdentifierDefinition>("4", INTEGER)
                )
            ),
            MakeIntrusive<TApplyDefinition>(
                MakeIntrusive<TIdentifierDefinition>("f"),
                MakeIntrusive<TApplyDefinition>(
                    MakeIntrusive<TIdentifierDefinition>("f"),
                    MakeIntrusive<TIdentifierDefinition>("true", BOOLEAN)
                )
            )
        );
        auto letNode = MakeIntrusive<TLetDefinition>(
            "f",
            MakeIntrusive<TLambdaDefinition>("x", MakeIntrusive<TIdentifierDefinition>("x")),
            pairNode
        );

        TRegistry registry;
        auto firstVar = MakeIntrusive<TTypeVariable>();
        auto secondVar = MakeIntrusive<TTypeVariable>();
        TTypeConstructor::TPtr pairType = MakeIntrusive<TTypeOperator>("pair", TVector<TTypeConstructor::TPtr>{firstVar, secondVar});
        registry["pair"].emplace_back(MakeIntrusive<TFunctionConstructor>(
            firstVar,
            MakeIntrusive<TFunctionConstructor>(secondVar, pairType)
        ));

        TTypeConstructor::TPtr inferredType = AnalyzeType(*letNode, registry);
        TTypeConstructor::TPtr expectedType = MakeIntrusive<TTypeOperator>("pair", TVector<TTypeConstructor::TPtr>{INTEGER, BOOLEAN});
        UNIT_ASSERT_VALUES_EQUAL(*inferredType, *expectedType);
    }

    Y_UNIT_TEST(TestTupleApply) {
        TRegistry registry;
        registry["conv"].emplace_back(MakeIntrusive<TFunctionConstructor>(
            MakeIntrusive<TTupleConstructor>(TVector<TTypeConstructor::TPtr>{
                MakeIntrusive<TTypeVariable>()
            }),
            DOUBLE_VALUE
        ));
        auto letNode = MakeIntrusive<TLetDefinition>(
            "f",
            MakeIntrusive<TApplyDefinition>(
                MakeIntrusive<TIdentifierDefinition>("conv"),
                MakeIntrusive<TTupleDefinition>(TVector<TDefinition::TPtr>{
                    MakeIntrusive<TIdentifierDefinition>("signal_ahhh", HISTOGRAM_VALUE)
                })
            ),
            MakeIntrusive<TIdentifierDefinition>("f")
        );
        TTypeConstructor::TPtr inferredType = AnalyzeType(*letNode, registry);
        UNIT_ASSERT_VALUES_EQUAL(*inferredType, *DOUBLE_VALUE);
    }

    Y_UNIT_TEST(TestListApply) {
        TRegistry registry;
        auto& hmergeOverloads(registry["hmerge"]);
        hmergeOverloads.emplace_back(MakeIntrusive<TFunctionConstructor>(
            MakeIntrusive<TListConstructor>(HISTOGRAM_VALUE),
            HISTOGRAM_VALUE
        ));
        hmergeOverloads.emplace_back(MakeIntrusive<TFunctionConstructor>(
            MakeIntrusive<TListConstructor>(DOUBLE_VALUE),
            HISTOGRAM_VALUE
        ));
        hmergeOverloads.emplace_back(MakeIntrusive<TFunctionConstructor>(
            MakeIntrusive<TListConstructor>(MakeIntrusive<TTypeVariable>()),
            HISTOGRAM_VALUE
        ));

        auto firstLetNode = MakeIntrusive<TLetDefinition>(
            "f",
            MakeIntrusive<TApplyDefinition>(
                MakeIntrusive<TIdentifierDefinition>("hmerge"),
                MakeIntrusive<TListDefinition>(TVector<TDefinition::TPtr>{
                    MakeIntrusive<TIdentifierDefinition>("signal1_ahhh", HISTOGRAM_VALUE),
                    MakeIntrusive<TIdentifierDefinition>("signal2_ahhh", HISTOGRAM_VALUE)
                })
            ),
            MakeIntrusive<TIdentifierDefinition>("f")
        );
        TTypeConstructor::TPtr firstInferredType = AnalyzeType(*firstLetNode, registry);
        UNIT_ASSERT_VALUES_EQUAL(*firstInferredType, *HISTOGRAM_VALUE);

        auto secondLetNode = MakeIntrusive<TLetDefinition>(
            "f",
            MakeIntrusive<TApplyDefinition>(
                MakeIntrusive<TIdentifierDefinition>("hmerge"),
                MakeIntrusive<TListDefinition>(TVector<TDefinition::TPtr>{
                    MakeIntrusive<TIdentifierDefinition>("signal1_summ", DOUBLE_VALUE),
                    MakeIntrusive<TIdentifierDefinition>("signal2_summ", DOUBLE_VALUE)
                })
            ),
            MakeIntrusive<TIdentifierDefinition>("f")
        );
        TTypeConstructor::TPtr secondInferredType = AnalyzeType(*secondLetNode, registry);
        UNIT_ASSERT_VALUES_EQUAL(*secondInferredType, *HISTOGRAM_VALUE);
    }
}
