grammar TAldan;

options {
    language=Cpp;
}

@parser::header
{
#include "TAldanLexer.h"
#include <util/generic/string.h>
#include <util/stream/output.h>
}

root:
    exp EOF
    ;

explist
    : exp (',' exp)*
    ;

exp
    : 'nil' | 'false' | 'true'
    | number
    | varOrExp
    | functioncall
    | <assoc=right> exp operatorPower exp
    | operatorUnary exp
    | exp operatorMulDivMod exp
    | exp operatorAddSub exp
    | exp operatorComparison exp
    | exp operatorAnd exp
    | exp operatorOr exp
    | exp operatorBitwise exp
    ;

functioncall
    : funcname '(' explist? ')'
    ;

funcname
    : NAME
    ;

varOrExp
    : var | '(' exp ')'
    ;

var
    : ( NAME | pattern )+
    ;

pattern
    : '<' var ('|' var)* '>'
    ;

operatorOr
    : 'or'
    ;

operatorAnd
    : 'and'
    ;

operatorComparison
    : '<' | '>' | '<=' | '>=' | '~=' | '=='
    ;

operatorAddSub
    : '+' | '-'
    ;

operatorMulDivMod
    : '*' | '/' | '%' | '//'
    ;

operatorBitwise
    : '&' | '|' | '<<' | '>>'
    ;

operatorPower
    : '^'
    ;

operatorUnary
    : 'not' | '-';

number
    : INT | HEX | FLOAT | HEX_FLOAT
    ;

// LEXER

NAME
    : [a-zA-Z_][a-zA-Z_0-9]*
    ;

INT
    : Digit+
    ;

HEX
    : '0' [xX] HexDigit+
    ;

FLOAT
    : Digit+ '.' Digit* ExponentPart?
    | '.' Digit+ ExponentPart?
    | Digit+ ExponentPart
    ;

HEX_FLOAT
    : '0' [xX] HexDigit+ '.' HexDigit* HexExponentPart?
    | '0' [xX] '.' HexDigit+ HexExponentPart?
    | '0' [xX] HexDigit+ HexExponentPart
    ;

fragment
ExponentPart
    : [eE] [+-]? Digit+
    ;

fragment
HexExponentPart
    : [pP] [+-]? Digit+
    ;

fragment
Digit
    : [0-9]
    ;
fragment
HexDigit
    : [0-9a-fA-F]
    ;

COMMENT
    : '#' ( ~[\n]* ) ( '\n' | EOF ) -> channel(HIDDEN)
    ;

WS
    : [ \t\r\n]+ -> skip
    ;
