#include "patterns.h"

#include <infra/yasm/aldan/common/exceptions.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NYasm::NAldan;

Y_UNIT_TEST_SUITE(TAldanPatternsTest) {

    Y_UNIT_TEST(TestGoodPatterns) {
        UNIT_ASSERT_VALUES_EQUAL(
            ParsePatterns("signal_<yasm|juggler>_<sas|msk_<iva|myt>|man|vla>_summ"),
            (TVector<TString>{
                "signal_yasm_sas_summ",
                "signal_yasm_msk_iva_summ",
                "signal_yasm_msk_myt_summ",
                "signal_yasm_man_summ",
                "signal_yasm_vla_summ",
                "signal_juggler_sas_summ",
                "signal_juggler_msk_iva_summ",
                "signal_juggler_msk_myt_summ",
                "signal_juggler_man_summ",
                "signal_juggler_vla_summ"
            })
        );
        UNIT_ASSERT_VALUES_EQUAL(
            ParsePatterns("start_<yasm|juggler>"),
            (TVector<TString>{
                "start_yasm",
                "start_juggler"
            })
        );
        UNIT_ASSERT_VALUES_EQUAL(
            ParsePatterns("<yasm|juggler>_end"),
            (TVector<TString>{
                "yasm_end",
                "juggler_end"
            })
        );
    }

    Y_UNIT_TEST(TestBadPatterns) {
        UNIT_ASSERT_EXCEPTION(ParsePatterns("start_<>_end"), TParsingError);
        UNIT_ASSERT_EXCEPTION(ParsePatterns(""), TParsingError);
    }

    Y_UNIT_TEST(TestLimits) {
        UNIT_ASSERT(!ParsePatterns("<a|b|c|d|e>_<a|b|c|d|e>_<a|b|c|d>").empty());
        UNIT_ASSERT_EXCEPTION(ParsePatterns("<a|b|c|d|e>_<a|b|c|d|e>_<a|b|c|d|e>"), TParsingError);
    }
}
