#pragma once

#include <infra/yasm/aldan/common/ast.h>
#include <infra/yasm/aldan/infer/augment.h>
#include <infra/yasm/aldan/infer/constructors_set.h>

#include "virtual_machine.h"

namespace NYasm::NAldan {
    class IFunctionDescriptor {
    public:
        virtual ~IFunctionDescriptor() = default;

        virtual TString GetFunctionName() const = 0;
        virtual TVector<TTypeConstructor::TPtr> GetFunctionTypes() const = 0;
        virtual void GenerateInstructions(TVirtualMachine& virtualMachine) const = 0;
    };

    class TInstructionFactory {
    public:
        using TDescriptorIndex = THashMap<TString, TTypeConstructorMap<const IFunctionDescriptor*>>;

        TTypeConstructor::TPtr GenerateInstructions(TNode& root, TVirtualMachine& virtualMachine) const;

        void AddDescriptor(THolder<IFunctionDescriptor> descriptor);

    private:
        TVector<THolder<IFunctionDescriptor>> Descriptors;
        TRegistry TypeRegistry;
        TDescriptorIndex DescriptorIndex;
    };

}
