#pragma once

#include <infra/yasm/common/points/value/types.h>

#include <util/generic/variant.h>
#include <util/generic/stack.h>

namespace NYasm::NAldan {
    struct TConstantIntegerOp {
        i64 Value = 0;
    };

    struct TConstantDoubleOp {
        double Value = 0.0;
    };

    struct TIntegerPlusOp {
    };

    struct TDoublePlusOp {
    };

    struct TIntegerMinusOp {
    };

    struct TDoubleMinusOp {
    };

    struct TIntegerDivideOp {
    };

    struct TDoubleDivideOp {
    };

    struct TIntegerMultiplyOp {
    };

    struct TDoubleMultiplyOp {
    };

    struct TInstruction {
        template <typename... Args>
        TInstruction(Args&&... args)
            : Instruction(std::forward<Args>(args)...)
        {
        }

        std::variant<
            TConstantIntegerOp,
            TConstantDoubleOp,
            TIntegerPlusOp,
            TDoublePlusOp,
            TIntegerMinusOp,
            TDoubleMinusOp,
            TIntegerDivideOp,
            TDoubleDivideOp,
            TIntegerMultiplyOp,
            TDoubleMultiplyOp>
            Instruction;
    };
}
