#pragma once

#include <infra/yasm/common/points/value/types.h>
#include <infra/yasm/common/points/hgram/hgram.h>

#include <util/generic/variant.h>
#include <util/generic/stack.h>

namespace NYasm::NAldan {
    struct TSummary {
        double Sum = 0.0;
        ui64 Count = 0;
        double Minimum = 0.0;
        double Maximum = 0.0;
        double Last = 0.0;
    };

    using TStackValue = std::variant<std::monostate, i64, double, TSummary, NZoom::NHgram::THgram>;

    class TVirtualMachineStack {
    public:
        bool Empty() {
            return Stack.empty();
        }

        template <typename... Args>
        void Push(Args&&... args) {
            Stack.emplace(std::forward<Args>(args)...);
        }

        TStackValue Pop() {
            Y_ASSERT(!Stack.empty());
            auto value = std::move(Stack.top());
            Stack.pop();
            return value;
        }

        template <class F>
        decltype(auto) Visit(F&& func) {
            Y_ASSERT(!Stack.empty());
            return func(Stack.top());
        }

        template <class F>
        decltype(auto) VisitAndPop(F&& func) {
            return func(Pop());
        }

        template <class F>
        decltype(auto) BinaryModify(F&& func) {
            return VisitAndPop([&](const auto& right) {
                return std::visit([&](const auto& left) {
                    return func(left, right, Stack.top());
                });
            });
        }

    private:
        TStack<TStackValue> Stack;
    };
}
