#pragma once

#include <infra/yasm/common/points/value/types.h>

#include "value_stack.h"
#include "instructions.h"

namespace NYasm::NAldan {
    class TVirtualMachine {
    public:
        NZoom::NValue::TValue Run();

        template <typename... Args>
        void AddInstruction(Args&&... args) {
            Instructions.emplace_back(std::forward<Args>(args)...);
        }

    private:
        TVirtualMachineStack Stack;
        TVector<TInstruction> Instructions;
    };
}
