#pragma once

#include <infra/yasm/common/labels/tags/instance_key.h>

#include <util/generic/strbuf.h>
#include <util/generic/hash.h>
#include <util/memory/pool.h>

namespace NCollector {
    class THserverResponse {
    public:
        class THostSignals {
        public:
            THostSignals(TStringBuf hostname, NTags::TInstanceKey instanceKey)
                : Hostname(hostname)
                , InstanceKey(instanceKey)
            {
            }

            TStringBuf GetHostname() const {
                return Hostname;
            }

            NTags::TInstanceKey GetInstanceKey() const {
                return InstanceKey;
            }

            const TVector<TStringBuf>& GetSignals() const {
                return Signals;
            }

            TVector<TStringBuf>& GetSignals() {
                return Signals;
            }

        private:
            const TStringBuf Hostname;
            const NTags::TInstanceKey InstanceKey;
            TVector<TStringBuf> Signals;
        };

        THserverResponse(TStringBuf incoming);

        TVector<THostSignals>::const_iterator begin() const {
            return HostSignals.begin();
        }

        TVector<THostSignals>::const_iterator end() const {
            return HostSignals.end();
        }

        TVector<TStringBuf> GetGroupHostNames(TStringBuf group) const {
            const auto it(Groups.find(group));
            if (it != Groups.end()) {
                return it->second;
            } else {
                return {};
            }
        }

    private:
        THashMap<TStringBuf, TVector<TStringBuf>> Groups;
        TVector<THostSignals> HostSignals;
    };
}
