#pragma once

#include <library/cpp/threading/light_rw_lock/lightrwlock.h>

#include <util/memory/pool.h>
#include <util/generic/hash_set.h>

namespace NCollector {
    class TStringCache : public TNonCopyable {
    public:
        TStringCache()
            : SignalPool(4UL * 1024UL * 1024UL)
        {
        }

        TStringBuf Get(TStringBuf signal) {
            {
                TLightReadGuard rg(Mutex);
                const auto it = SignalSet.find(signal);
                if (it != SignalSet.end()) {
                    return *it;
                }
            }

            TLightWriteGuard wg(Mutex);
            const auto it = SignalSet.find(signal);
            if (it != SignalSet.end()) {
                return *it;
            }

            return *SignalSet.emplace(SignalPool.AppendString(signal)).first;
        }

    private:
        TLightRWLock Mutex;
        TMemoryPool SignalPool;
        THashSet<TStringBuf> SignalSet;
    };
}
