#pragma once

#include <infra/yasm/collector/python/deserializers/hserver.h>

namespace NCollector {
    struct TGroupInfo {
        TString GroupName;
        TString MetaGroupName;
    };

    struct TClickhouseOptions {
        TString Host = "localhost";
        int Port = 9000;
        int Timeout = 5 * 60;
        TString DefaultDatabase = "default";
        TString User = "default";
        TString Password = "";

        TVector<TString> Tags = {"ctype", "prj", "geo", "tier"};

        TString InstancesTableName = "instances";
        TString SignalsTableName = "signals";
        TString CommonTableName = "common";

        // TODO: remove me!
        bool Dummy = false;
    };

    class TClickhouseTransmitter {
    public:
        TClickhouseTransmitter(const TClickhouseOptions& options);
        TClickhouseTransmitter();
        ~TClickhouseTransmitter();

        void HistoryExtend(const TVector<TGroupInfo>& groups, const THserverResponse& response);
        void RealtimeExtend(const TVector<TGroupInfo>& groups, const THserverResponse& response);

        void DumpInstances(bool force);
        void DumpSignals(bool force);
        void DumpCommon();

        void Reset();

    private:
        class TImpl;

        THolder<TImpl> Impl;
    };
}
